;=============================================================================;
;                                                                             ;
;                       Software License Agreement                            ;
;                                                                             ;
;   The software supplied herewith by Microchip Technology Incorporated       ;
;   (the "Company") for its dsPIC controller is intended and supplied to      ;
;   you, the Company's customer, for use solely and exclusively on            ;
;   Microchip dsPIC products. The software is owned by the Company and/or     ;
;   its supplier, and is protected under applicable copyright laws. All       ;
;   rights are reserved. Any use in violation of the foregoing                ;
;   restrictions may subject the user to criminal sanctions under             ;
;   applicable laws, as well as to civil liability for the breach of the      ;
;   terms and conditions of this license.                                     ;
;                                                                             ;
;   THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO WARRANTIES,        ;
;   WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO,     ;
;   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR        ;
;   PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY             ;
;   CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL         ;
;   DAMAGES, FOR ANY REASON WHATSOEVER.                                       ;
;                                                                             ;
;=============================================================================;
;                                                                             ;
; Assembly code interrupt service routine for Input Capture 1                 ;
;                                                                             ;
;=============================================================================;

        .equ __30F6014, 1
        .include "p30f6014.inc"

;------------------------------------------------------------------------------
;Global Declarations

        .global	__IC1Interrupt		;Declare Input Capture interrupt routine label


;------------------------------------------------------------------------------
;Variables

        .comm _DataBuffer,64
        .extern _InBufferPointer

;------------------------------------------------------------------------------
;Start of code

        .text				;Start of Code section

;------------------------------------------------------------------------------
;Input Capture 1 Interrupt Service Routine

__IC1Interrupt:	bclr	IFS0,#IC1IF	        ;Clear Input Capture 1 interrupt flag
                push    W0                      ;Save W0 so it can be used in ISR
                mov     IC1BUF,W0               ;Get input capture data
                mov     W0,[W8++]               ;Write to buffer
                pop     W0                      ;Restore W0
                retfie			        ;Return from interrupt

;------------------------------------------------------------------------------

    .end				;End of code in this file



